<?php

/**
 * Category Added
 *
 * @package     AutomatorWP\Integrations\GeoDirectory\Triggers\Category_Added
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if (!defined('ABSPATH')) exit;

class AutomatorWP_GeoDirectory_Category_Added extends AutomatorWP_Integration_Trigger
{

    public $integration = 'geodirectory';
    public $trigger = 'geodirectory_category_added';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register()
    {

        automatorwp_register_trigger($this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User adds a new category', 'automatorwp-pro' ),
            'select_option'     => __( 'User adds a <strong>new category</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User adds a new category %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User adds a new category', 'automatorwp-pro' ),
            'action'            => 'geodir_term_save_category_fields',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 3,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags'              => array_merge(
                automatorwp_utilities_times_tag()
            )
        ));
    }


    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int    $term_id  Term ID.
     * @param int    $tt_id    Term taxonomy ID.
     * @param string $taxonomy Taxonomy slug.
     */
    public function listener( $term_id, $tt_id, $taxonomy )
    {

        $user_id = get_current_user_id();

        // Bail if no user
        if ($user_id === 0) {
            return;
        }

        automatorwp_trigger_event(array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
            'term_id'       => $term_id,
        ));
    }
    
}

new AutomatorWP_GeoDirectory_Category_Added();
